﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AZVIC.Ei8htPOS.Entities;
using System.Net.Mail;
using System.Configuration;
using System.Windows;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.BAL;
using System.Management;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Constants
{
    public static class AppSession
    {
        private static string siteDesc = GetAppSettingsValue("siteAddress");

        public static bool pdShowProducts = GetAppSettingsValue("ShowProductsPoleDisplay").ToLower().Equals("true") ? true : false;

        public static bool pdShowConfirm = GetAppSettingsValue("ShowPaymentConfirmDisplay").ToLower().Equals("true") ? true : false;

        public static string BusinessHourEnd = GetAppSettingsValue("BusinessHourEnd");

        public static string BusinessHourStart = GetAppSettingsValue("BusinessHourStart");

        public static string PoleDisplayWelcomeText = GetAppSettingsValue("pdWelcomeText");

        public static string PoleDisplayPort = GetAppSettingsValue("PoleDisplayPort");

        public static string CashRegisterPort = GetAppSettingsValue("CashRegisterPort");

        //public static string RegNo = GetAppSettingsValue("RegNumber");

        private static AppSettingsReader SettingsReader;

        public static string GetAppSettingsValue(string Key)
        {
            SettingsReader = new AppSettingsReader();
            return SettingsReader.GetValue(Key, typeof(string)).ToString();
        }

        public static bool IsHappyHour
        {

            get
            {
                List<HappyHours> _happyHours = HappyHourPromoBL.GetList(Guid.Empty);
                if (_happyHours != null && _happyHours.Count > 0)
                {
                    _happyHours = _happyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
                }
                _happyHours = _happyHours == null ? new List<HappyHours>() : _happyHours;
                return _happyHours.Where(a => a.StartTime.Hour <= DateTime.Now.Hour && DateTime.Now.Hour < a.EndTime.Hour).Any();
            }

            set { }
        }

        #region Config Values

        public static string OrderFrom = GetAppSettingsValue("OrdersFrom");

        public static string InvoiceAddress = GetAppSettingsValue("Address");

        public static string ImagePath = GetAppSettingsValue("ImagePath");

        public static string NoImagePath = GetAppSettingsValue("NoImagePath");

        public static string LocalImagePath = GetAppSettingsValue("ImagePathLocal");

        public static string ImagePathLocal = GetAppSettingsValue("ImagePathLocal");

        public static string LogoPath = GetAppSettingsValue("LogoPath");

        public static string CashDrawerName = GetAppSettingsValue("CashDrawerName");

        public static bool ApplyGST = bool.Parse(GetAppSettingsValue("ApplyGST"));

        public static decimal GSTPercent = decimal.Parse(GetAppSettingsValue("GSTPercent"));

        public static bool ApplyRoundTotal = bool.Parse(GetAppSettingsValue("ApplyRoundTotal"));

        public static decimal RoundMarkup = decimal.Parse(GetAppSettingsValue("RoundMarkup"));

        public static bool ApplyServiceTax = bool.Parse(GetAppSettingsValue("ApplyServiceTax"));

        public static decimal ServiceTaxPercent = decimal.Parse(GetAppSettingsValue("ServiceTaxPercent"));

        public static string ShopName = GetAppSettingsValue("ShopName");

        public static string ShopAddress = GetAppSettingsValue("ShopAddress");

        public static string ThankyouMessage = GetAppSettingsValue("ThankyouMessage");

        public static string AppLogoPath = System.AppDomain.CurrentDomain.BaseDirectory;

        #region OCBC Terminal Values

        public static string OCBCTerminalPortName = GetAppSettingsValue("OCBCTerminalPortName");

        public static string OCBCTerminalBaudRate = GetAppSettingsValue("OCBCTerminalBaudRate");

        public static string OCBCTerminalDataBits = GetAppSettingsValue("OCBCTerminalDataBits");

        public static string OCBCTerminalStopBits = GetAppSettingsValue("OCBCTerminalStopBits");

        public static string OCBCTerminalParity = GetAppSettingsValue("OCBCTerminalParity");

        public static string OCBCConnected = GetAppSettingsValue("OCBCConnected");

        #endregion

        #region NETS Terminal Values

        public static string NETSTerminalPortName = GetAppSettingsValue("NETSTerminalPortName");

        public static string NETSTerminalBaudRate = GetAppSettingsValue("NETSTerminalBaudRate");

        public static string NETSTerminalDataBits = GetAppSettingsValue("NETSTerminalDataBits");

        public static string NETSTerminalStopBits = GetAppSettingsValue("NETSTerminalStopBits");

        public static string NETSTerminalParity = GetAppSettingsValue("NETSTerminalParity");

        public static string NETSConnected = GetAppSettingsValue("NETSConnected");

        public static int NETSTimeout = Convert.ToInt32(GetAppSettingsValue("NETSTimeout"));

        #endregion

        #endregion

        #region App Session Values
        public static Orders CurrentOrders { get; set; }

        public static List<Orders> HeldTransactions { get; set; }

        public static UserAccount CurrentAdminUser { get; set; }

        public static UserAccount CurrentUser { get; set; }

        //public static List<UserAccount> UserList { get; set; }

        public static List<Products> ProductsList { get; set; }

        public static List<ProductCategory> CategoryList { get; set; }

        public static List<ProductSubCategory> ProductSubCategoryList { get; set; }

        public static List<ProductsXCategory> ProductsXCategoryList { get; set; }

        public static List<ProductBrand> BrandList { get; set; }

        public static List<ProductColor> ColorList { get; set; }

        public static List<ProductMeasurement> MeasurementList { get; set; }

        public static List<Promotion> PromotionList { get; set; }

        public static OCBCHelper.OCBCTransactionResponse CurrentOCBCTransaaction { get; set; }

        public static NETSHelper.TransactionResponse CurrentNETSTransaction { get; set; }

        #endregion

        #region App Session Functions
        public static void ClearCurrentSession()
        {
            CurrentOrders = null;
            HeldTransactions = null;
            CurrentUser = CurrentAdminUser = null;
            ProductsList = null;
            CategoryList = null;
            ProductSubCategoryList = null;
            ProductsXCategoryList = null;
            BrandList = null;
            ColorList = null;
            MeasurementList = null;
        }

        //public static void AddDummyProductToCart(Orders currentOrder, Products currentProduct, decimal orderPrice, string discountType, decimal discountValue, int qty, int discountQty, string remarks, bool increaseQty, bool isMiscellaneous,string DisplayName,int DisplayQty)
        //{
        //    bool foundOrderItem = false;

        //    foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
        //    {
        //        if (od.ProductID == currentProduct.UniqueID)
        //        {
        //            if (!isMiscellaneous)
        //            {
        //                if (increaseQty)
        //                {
        //                    od.Quantity += (qty*DisplayQty)/* + discountQty*/;
        //                    od.DiscountQuantity += discountQty;
        //                }
        //                else
        //                {
        //                    od.Quantity = qty*DisplayQty /* + discountQty*/;
        //                    od.DiscountQuantity = discountQty;
        //                }

        //                od.Amount = od.OrderPrice * (od.Quantity /*- od.DiscountQuantity*/);
        //                od.Remarks = remarks;
        //                foundOrderItem = true;
        //            }
        //            else
        //            {
        //                if (od.ProductName == currentProduct.ProductName && od.UnitPrice == currentProduct.UnitPrice &&
        //                    od.OrderPrice == currentProduct.UnitPrice)
        //                {
        //                    if (increaseQty)
        //                        od.Quantity += qty*DisplayQty;
        //                    else
        //                        od.Quantity = qty*DisplayQty;

        //                    od.Amount = od.OrderPrice * od.Quantity;
        //                    foundOrderItem = true;
        //                }
        //            }

        //            //if (od.DiscountValue <= 0)
        //            //{
        //            od.DiscountType = discountType;
        //            od.DiscountValue = discountValue;
        //            od.DisplayQuantity = qty;
        //            od.DisplayName = DisplayName;
        //            //}
        //            if (od.Quantity <= 0)
        //            {
        //                RemoveProductFromCart(currentOrder, od);
        //            }
        //            if (foundOrderItem)
        //                break;
        //        }
        //    }

        //    if (!foundOrderItem && qty > 0)
        //    {
        //        OrdersDetails ordItem = new OrdersDetails();
        //        ordItem.ProductID = currentProduct.UniqueID;
        //        ordItem.ProductName = currentProduct.ProductName;
        //        ordItem.UnitPrice = currentProduct.UnitPrice;
        //        ordItem.OrderPrice = orderPrice;
        //        ordItem.DiscountType = discountType;
        //        ordItem.DiscountValue = discountValue;
        //        ordItem.Quantity = qty*DisplayQty /*+ discountQty*/;
        //        ordItem.DiscountQuantity = discountQty;
        //        ordItem.Amount = (ordItem.OrderPrice * (ordItem.Quantity /*- ordItem.DiscountQuantity*/));
        //        ordItem.CanApplyDiscount = (discountValue > 0 ? false : true);
        //        ordItem.EarliestAvailableDays = currentProduct.EarliestAvailableDays;
        //        ordItem.IsMiscellaneous = isMiscellaneous;
        //        ordItem.Remarks = remarks;
        //        ordItem.DisplayQuantity = qty;
        //        ordItem.DisplayName = DisplayName;
        //        currentOrder.OrdersDetailsList.Add(ordItem);
        //    }
        //}

        public static void AddProductToCart(Orders currentOrder, Products currentProduct, decimal orderPrice, string discountType, decimal discountValue, int qty, int discountQty, string remarks, bool increaseQty, bool isMiscellaneous, int DisplayQty, string DisplayName = "")
        {
            bool foundOrderItem = false;

            foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
            {
                if (od.ProductID == currentProduct.UniqueID)
                {
                    if (!isMiscellaneous)
                    {
                        if (increaseQty)
                        {
                            od.Quantity += qty/* + discountQty*/;
                            od.DiscountQuantity += discountQty;
                        }
                        else
                        {
                            od.Quantity = qty /* + discountQty*/;
                            od.DiscountQuantity = discountQty;
                        }

                        od.Amount = od.OrderPrice * (od.Quantity /*- od.DiscountQuantity*/);
                        od.Remarks = remarks;
                        foundOrderItem = true;
                    }
                    else
                    {
                        if (od.ProductName == currentProduct.ProductName && od.UnitPrice == currentProduct.UnitPrice &&
                            od.OrderPrice == currentProduct.UnitPrice)
                        {
                            if (increaseQty)
                                od.Quantity += qty;
                            else
                                od.Quantity = qty;

                            od.Amount = od.OrderPrice * od.Quantity;
                            foundOrderItem = true;
                        }
                    }

                    //if (od.DiscountValue <= 0)
                    //{
                    od.DiscountType = discountType;
                    od.DiscountValue = discountValue;
                    od.DisplayName = DisplayName;
                    od.DisplayQuantity += DisplayQty;
                    //}
                    if (od.Quantity <= 0)
                    {
                        RemoveProductFromCart(currentOrder, od);
                    }
                    if (foundOrderItem)
                        break;
                }
            }

            if (!foundOrderItem && qty > 0)
            {
                OrdersDetails ordItem = new OrdersDetails();
                ordItem.ProductID = currentProduct.UniqueID;
                ordItem.ProductName = currentProduct.ProductName;
                ordItem.UnitPrice = currentProduct.UnitPrice;
                ordItem.OrderPrice = orderPrice;
                ordItem.DiscountType = discountType;
                ordItem.DiscountValue = discountValue;
                ordItem.Quantity = qty /*+ discountQty*/;
                ordItem.DiscountQuantity = discountQty;
                ordItem.Amount = (ordItem.OrderPrice * (ordItem.Quantity /*- ordItem.DiscountQuantity*/));
                ordItem.CanApplyDiscount = (discountValue > 0 ? false : true);
                ordItem.EarliestAvailableDays = currentProduct.EarliestAvailableDays;
                ordItem.IsMiscellaneous = isMiscellaneous;
                ordItem.DisplayQuantity += DisplayQty;
                ordItem.DisplayName = DisplayName;
                ordItem.Remarks = remarks;

                currentOrder.OrdersDetailsList.Add(ordItem);
            }
        }

        public static void RemoveProductFromCart(Orders currentOrder, OrdersDetails currentProduct)
        {
            foreach (OrdersDetails oDetails in currentOrder.OrdersDetailsList)
            {
                if (oDetails.ProductID == currentProduct.ProductID)
                {
                    if (!currentProduct.IsMiscellaneous)
                    {
                        currentOrder.OrdersDetailsList.Remove(oDetails);
                        break;
                    }
                    else
                    {
                        if (oDetails.ProductName == currentProduct.ProductName && oDetails.UnitPrice == currentProduct.UnitPrice &&
                            oDetails.OrderPrice == currentProduct.OrderPrice && oDetails.Quantity == currentProduct.Quantity)
                        {
                            currentOrder.OrdersDetailsList.Remove(oDetails);
                            break;
                        }
                    }
                }
            }
        }

        public static void UpdateOrderProductQty(Orders currentOrder)
        {
            foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
            {
                Products curProd = ProductsBL.GetItem(od.ProductID, string.Empty);
                if (curProd != null)
                {
                    if (!curProd.IsMiscellaneous && curProd.IsSales)
                    {
                        //Is Sales is used as Inventory Tracking Flag.

                        curProd.Mode = GlobalConfigurations.Mode.Update;
                        if (curProd.ActualStock > (od.Quantity + od.DiscountQuantity))
                        {
                            curProd.ActualStock = curProd.ActualStock - (od.Quantity + od.DiscountQuantity);
                        }
                        else
                        {
                            //int qty = od.Quantity - curProd.ActualStock;
                            //curProd.ActualStock = 0;
                            //curProd.ReserveStock = curProd.ReserveStock - qty;

                            int qty = (od.Quantity + od.DiscountQuantity) - curProd.ActualStock;
                            curProd.ActualStock = 0;
                            if (curProd.ReserveStock >= qty)
                                curProd.ReserveStock = curProd.ReserveStock - qty;
                            else
                                curProd.ReserveStock = 0;
                        }
                        ProductsBL.Save(curProd);

                        if (curProd.ShareInventoryID != null && curProd.ShareInventoryID != Guid.Empty)
                        {
                            Entities.Products AliasProduct = ProductsBL.GetItem(curProd.ShareInventoryID, string.Empty);
                            AliasProduct.ActualStock = curProd.ActualStock;
                            AliasProduct.ReserveStock = curProd.ReserveStock;
                            ProductsBL.Save(AliasProduct);
                        }

                        curProd = ProductsBL.GetItem(curProd.UniqueID, string.Empty);
                        if ((curProd.ActualStock + curProd.ReserveStock) <= curProd.LowStockIndication)
                        {
                            //AppSession.SendProductStockEmail(curProd);
                        }
                    }
                }
            }

            AppSession.ProductsList = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).ToList<Products>();
            bool IsConnectedToInternet = GlobalConfigurations.AppConfiguration.IsConnectedToInternet();
            AppSession.ProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 = IsConnectedToInternet ?
                (string.IsNullOrEmpty(product.Image1) ? AppSession.ImagePath + AppSession.NoImagePath : AppSession.ImagePath + product.Image1)
                : (string.IsNullOrEmpty(product.Image1) ? AppSession.LocalImagePath + AppSession.NoImagePath : AppSession.LocalImagePath + product.Image1));
        }

        public static bool CheckPrinterAssigned()
        {
            if (string.IsNullOrEmpty(Properties.Settings.Default.InvoicePrinter) || string.IsNullOrEmpty(Properties.Settings.Default.BarcodePrinter))
            {
                POSRetail.Controls.SelectPrinter printer = new POSRetail.Controls.SelectPrinter();
                printer.Owner = Application.Current.MainWindow;
                printer.ShowInTaskbar = false;
                printer.ShowDialog();
                if (!bool.Parse(printer.Tag.ToString()))
                    CheckPrinterAssigned();
            }
            return true;
        }

        public static decimal RoundAmount(decimal passedValue)
        {
            return Math.Round((Math.Round(passedValue * 20, MidpointRounding.AwayFromZero) / 20), 2);
        }

        #endregion

        #region ProgressDialog
        static POSRetail.Controls.Loading.ProgressDialog pd = null;
        public static void ShowProgressDialog()
        {
            pd = new POSRetail.Controls.Loading.ProgressDialog();
            pd.Owner = Application.Current.MainWindow;
            pd.ShowInTaskbar = false;
            pd.Show();
        }

        public static void CloseProgressDialog()
        {
            if (pd != null)
            {
                pd.Close();
            }
            pd = null;
        }

        #endregion

        #region Welcome Email

        public static void SendWelcomeEmail(UserAccount Customer)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "Welcome to Ei8htPOS";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', ;  background-color:rgba(77,77,77,.15);padding: 15px; line-height: 25px;"">
                                        <p><h2>Dear " + Customer.FirstName + " " + Customer.LastName + ",</h2>" + @"</p>
                                        <p>
                                            <h3>Welcome to Ei8htPOS!</h3>
                                        </p>
                                        <p>
                                            Thank you for your purchase at Ei8htPOS! We want to make sure your shopping experience as fast, easy and thoroughly enjoyable as possible. 
                                        </p>
                                        <p>You can also purchase our products online through our webstie <a href=""Ei8htPOS.com""><b>www.Ei8htPOS.com</b></a>. Please check out the website for incredible deals & discounts.</p>
                                        <p>Your Ei8htPOS Account details are give below:<br/><br/>
                                        <table style=""width:500px;"">
                                        <tr>
                                        <td>
                                        <b> UserName : </b>
                                        </td>
                                        <td>" + Customer.UserName + @"</td>
                                        </tr><tr>
                                        <td> <b>Password : </b></td>
                                        <td>" + ValidationUtility.DecryptPassword(Customer.UPassword) + @"</td>
                                        </tr>
                                        </table>
                                        </p>
                                        <p>If you have any queries, please feel free to email us at <a href=""mailto:support@ei8htpos.com"">support@Ei8htPOS.com</a></p>
                                        <i>Thanks,<br/>
                                        Ei8htPOS Customer Service Team.</i>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, Customer.UniqueID);

            SendEmail(subject, clientBodyMessage, string.Empty, Customer.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendProductStockEmail(Products currentProd)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "Ei8htPOS - Product Stock";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear Admin</p>
                                        <p>
                                            The below product is going the reach out of stock.
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    PRODUCT NAME
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                   ACTUAL QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    RESERVE QTY
                                                </th>
                                            </tr>
                                            <tr>
                                                <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">1</td>
                                                <td style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                    currentProd.ProductName +
                                                @"</td>
                                                <td style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                    + currentProd.ActualStock.ToString() +
                                                @"</td>
                                                <td align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                    + currentProd.ReserveStock.ToString() +
                                                @"</td>
                                          </tr>
                                        </table>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(false, Guid.Empty);

            SendEmail(subject, clientBodyMessage, string.Empty, GetAppSettingsValue("FromEmailAddress"), new string[] { }, new string[] { }, true, true, true);
        }

        public static string EmailHeader()
        {
            string header = string.Empty;

            header = @"<html lang=""en"" xmlns=""http://www.w3.org/1999/xhtml"">
                        <head><title></title>
                        </head>
                        <body style=""font-family: 'Arial', 'sans-serif'; font-size: 15px; padding: 0; margin: 0;"">
                            <table width=""740"" cellspacing=""0"" cellpadding=""0"" align=""center"" style=""padding: 5px 3px 5px 10px;"">
                                <tr>
                                    <td align=""left"">
                                        <img src=""" + siteDesc + "EmailImages/logo.jpg" + @""" alt="""" border=""0"" width=""150px"" height=""150px"" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <hr style=""margin-bottom: 20px;"" />
                                    </td>
                                </tr>";

            return header;
        }

        public static string EmailFooter(bool addCustomerInfo, Guid userAccountID)
        {
            string footer;

            footer = @"<tr>
                        <td style=""font-family: 'Arial', 'sans-serif';"">
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 30px; font-size: 15px;"">
                                Yours sincerely,<br />
                                Ei8htPOS
                            </div>
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 30px; font-size: 12px; text-align: center; color: #fff; background-color: #4d4d4d;line-height:20px;"">
                                Visit <a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">ei8htpos.sg</a> 
                                | " + ((addCustomerInfo && userAccountID != Guid.Empty) ? @"<a href=""" + siteDesc + @"MyProfile.aspx?UniqueID=" + userAccountID.ToString() + @""" style=""color: #fff; text-decoration: none;"">Update Your Information</a> | " : string.Empty)
                                   +
                                @"<a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">Contact Us</a> 
                                |
                                <a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">Facebook</a><br>
                                © " + DateTime.Now.Year.ToString() + @" ei8htpos.com All Rights Reserved.
                            </div>
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 10px; font-size: 10px; text-align: left;"">
                                Disclaimer: This message (and any attachments) may contain information that is confidential, proprietary, 
                                privileged or otherwise protected by law. The message is intended solely for the named addressee (or a person responsible for delivering it to the addressee). 
                                If you are not the intended recipient of the message or if you have received this message in error, 
                                please delete it from your system and notify us immediately at <a href=""mailto:support@ei8htpos.com"" style=""color: #4d4d4d; text-decoration: none;"">support@ei8htpos.com</a>.
                            </div>
                        </td>
                     </tr>
                    </table>
                   </body>
                  </html>";

            return footer;
        }

        public static void SendEmail(string emailSubject, string emailMessage, string fromEmail, string toEmail, string[] ccList, string[] bccList, bool isBodyHtml, bool sendToCC, bool sendToBCC)
        {
            try
            {

                SmtpClient client = new SmtpClient(GetAppSettingsValue("SmtpServer"), int.Parse(GetAppSettingsValue("smtpport")));
                client.EnableSsl = bool.Parse(GetAppSettingsValue("ssl"));
                client.Credentials = new System.Net.NetworkCredential(GetAppSettingsValue("FromEmailAddress"), GetAppSettingsValue("smtppassword"));
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                MailMessage msg = new MailMessage();
                msg.IsBodyHtml = isBodyHtml;
                msg.Subject = emailSubject;
                msg.Body = emailMessage;
                try
                {
                    if (fromEmail.Trim().Length != 0)
                        msg.From = new MailAddress(fromEmail.Trim());
                    else
                        msg.From = new MailAddress(GetAppSettingsValue("FromEmailAddress").ToString());
                    if (toEmail.Trim().Length != 0)
                        msg.To.Add(new MailAddress(toEmail));
                    else
                        msg.To.Add(new MailAddress(GetAppSettingsValue("ToEmailAddress").ToString()));
                }
                catch { }

                //CC List From Code
                foreach (string cc in ccList)
                {
                    try
                    {
                        msg.CC.Add(cc);
                    }
                    catch { }
                }

                //CC List from Web.config
                if (sendToCC)
                {
                    string[] existingCClist = GetAppSettingsValue("CCEmailAddress").Split(new char[] { ';' });
                    foreach (string cc in existingCClist)
                    {
                        if (cc.Trim().Length != 0)
                        {
                            try
                            {
                                msg.CC.Add(cc);
                            }
                            catch { }
                        }
                    }
                }


                //BCC List From Code
                foreach (string bcc in bccList)
                {
                    try
                    {
                        msg.Bcc.Add(bcc);
                    }
                    catch { }
                }
                //BCC List from web.config
                if (sendToBCC)
                {
                    string[] existingBCCList = GetAppSettingsValue("BCCEmailAddress").Split(new char[] { ';' });
                    foreach (string bcc in existingBCCList)
                    {
                        if (bcc.Trim().Length != 0)
                        {
                            try
                            {
                                msg.Bcc.Add(bcc);
                            }
                            catch { }
                        }
                    }
                }

                client.Send(msg);
            }
            catch { }
        }

        #endregion

        /// <summary>
        public static void OpenCashDrawer()
        {
            string caption = string.Empty;
            ManagementObjectSearcher searcher = new ManagementObjectSearcher(@"Select * From Win32_PnPEntity WHERE Caption like '%" + CashDrawerName + "%'");
            foreach (ManagementObject device in searcher.Get())
            {
                caption = (string)device.GetPropertyValue("Caption");
            }
            if (!string.IsNullOrEmpty(caption))
            {
                string portNo = CashRegisterPort;
                int start = caption.IndexOf("(");
                int end = caption.IndexOf(")");
                portNo = caption.Substring(start, end - start);
                portNo = portNo.Replace("(", "");

                byte[] cashDrawerCmd = new byte[] { 27, 112, 0, 25, 250 };
                System.IO.Ports.SerialPort comPort = new System.IO.Ports.SerialPort();
                comPort = new System.IO.Ports.SerialPort()
                {
                    PortName = portNo,
                    BaudRate = 9600,
                    DataBits = 8,
                    Parity = System.IO.Ports.Parity.None,
                    StopBits = System.IO.Ports.StopBits.One,
                    Handshake = System.IO.Ports.Handshake.RequestToSend
                };
                try
                {
                    comPort.Open();
                    comPort.Write(cashDrawerCmd, 0, cashDrawerCmd.Length);
                    comPort.Close();
                }
                catch { }
            }
            else
            {
                App.ShowMessageBox("Cash Drawer is not connected with the POS. Please connect the Cash Drawer and try again.", "Ei8ht POS");
            }
            //        else
            //            return str + " , " + str1;
        }
    }
}
